/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ContourPlot;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.Histogramme;
import cds.aladin.MyLabel;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanContour;
import cds.aladin.PlanImage;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class FrameContour
extends JFrame
implements ActionListener {
    protected String TITRE;
    protected String CLOSE;
    protected String RESET;
    protected String SUBMIT;
    protected String NEWLEVEL;
    protected String SHOWHELP;
    protected String HIDEHELP;
    protected String SMOOTHINFO;
    protected String NOISEINFO;
    protected String ZOOMINFO;
    protected String CHOOSELEVEL;
    protected String GENERATE;
    protected String SMOOTH;
    protected String LEVEL;
    protected String MANUALLY;
    protected String USESM;
    protected String REDUCE;
    protected String CONSIDER;
    protected String TITRE2;
    static final Font HELPFONT = Aladin.SPLAIN;
    boolean showHelp = false;
    boolean flagHide = true;
    JPanel p;
    JLabel lab1;
    MyLabel smoothInfo;
    MyLabel noiseInfo;
    MyLabel zoomInfo;
    JButton helpBtn;
    JButton submitBtn;
    JCheckBox smoothCb;
    JCheckBox noisecb;
    PlanImage pimg;
    JComboBox nbLevelsChoice;
    JComboBox smooothLevelChoice;
    JCheckBox currentZoomOnly;
    private Histogramme hist;
    private Color[] couleurs = null;
    private double[] levels;
    Aladin a;
    Curseur curs;
    int etat = -4;
    private RectangleD memoRzoom = null;
    private static final Insets BUTTON_INSETS = new Insets(0, 2, 0, 2);

    protected void createChaine() {
        this.TITRE = Aladin.chaine.getString("CPTITRE");
        this.TITRE2 = Aladin.chaine.getString("CPTITRE2");
        this.CLOSE = Aladin.chaine.getString("CLOSE");
        this.RESET = Aladin.chaine.getString("RESET");
        this.SUBMIT = Aladin.chaine.getString("CPSUBMIT");
        this.NEWLEVEL = Aladin.chaine.getString("CPNEWLEVEL");
        this.SHOWHELP = Aladin.chaine.getString("CPSHOWHELP");
        this.HIDEHELP = Aladin.chaine.getString("CPHIDEHELP");
        this.SMOOTHINFO = Aladin.chaine.getString("CPSMOOTHINFO");
        this.NOISEINFO = Aladin.chaine.getString("CPNOISEINFO");
        this.ZOOMINFO = Aladin.chaine.getString("CPZOOMINFO");
        this.CHOOSELEVEL = Aladin.chaine.getString("CPCHOOSELEVEL");
        this.GENERATE = Aladin.chaine.getString("CPGENERATE");
        this.SMOOTH = Aladin.chaine.getString("CPSMOOTH");
        this.LEVEL = Aladin.chaine.getString("CPLEVEL");
        this.MANUALLY = Aladin.chaine.getString("CPMANUALLY");
        this.USESM = Aladin.chaine.getString("CPUSESM");
        this.REDUCE = Aladin.chaine.getString("CPREDUCE");
        this.CONSIDER = Aladin.chaine.getString("CPCONSIDER");
    }

    protected FrameContour(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITRE);
        this.lab1 = new JLabel(" " + this.SMOOTH);
        this.smoothInfo = new MyLabel(this.SMOOTHINFO, 0, HELPFONT);
        this.noiseInfo = new MyLabel(this.NOISEINFO, 0, HELPFONT);
        this.zoomInfo = new MyLabel(this.ZOOMINFO, 0, HELPFONT);
        this.pimg = this.a.calque.getFirstSelectedSimpleImage();
        this.setLocation(350, 200);
        this.hist = new Histogramme();
        this.curs = new Curseur(this.hist);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.initCouleurs();
        this.fillCouleurTriangle();
    }

    private JPanel getTopPanel() {
        int i;
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.insets = new Insets(1, 3, 2, 3);
        JPanel p = new JPanel();
        p.setLayout(g);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSELEVEL, 4, 2, Aladin.PLAIN), BorderFactory.createEmptyBorder(5, 5, 3, 5))));
        this.hist.setImage(this.pimg);
        c.anchor = 10;
        g.setConstraints(this.hist, c);
        p.add(this.hist);
        g.setConstraints(this.curs, c);
        p.add(this.curs);
        JPanel pGenerate = new JPanel();
        pGenerate.setLayout(new FlowLayout(0, 7, 5));
        JLabel l = new JLabel(this.GENERATE);
        pGenerate.add(l);
        l.setFont(Aladin.PLAIN);
        this.nbLevelsChoice = new JComboBox();
        this.nbLevelsChoice.addActionListener(this);
        for (i = 1; i <= 10; ++i) {
            this.nbLevelsChoice.addItem(new Integer(i));
        }
        for (i = 12; i <= 20; i += 2) {
            this.nbLevelsChoice.addItem(new Integer(i));
        }
        int defaultVal = 4;
        this.nbLevelsChoice.setSelectedIndex(defaultVal - 1);
        pGenerate.add(this.nbLevelsChoice);
        l = new JLabel(this.LEVEL);
        pGenerate.add(l);
        l.setFont(Aladin.PLAIN);
        this.createLevels(defaultVal);
        c.anchor = 17;
        g.setConstraints(pGenerate, c);
        p.add(pGenerate);
        JPanel pNewLevel = new JPanel();
        pNewLevel.setLayout(new FlowLayout(0, 7, 5));
        l = new JLabel(this.MANUALLY);
        pNewLevel.add(l);
        l.setFont(Aladin.PLAIN);
        pNewLevel.add(this.createButton(this.NEWLEVEL));
        c.insets = new Insets(0, 0, 0, 0);
        g.setConstraints(pNewLevel, c);
        p.add(pNewLevel);
        return p;
    }

    private JPanel getOptionsPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.insets = new Insets(1, 3, 2, 3);
        c.anchor = 17;
        JPanel p = new JPanel();
        p.setLayout(g);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 4, 2, Aladin.PLAIN), BorderFactory.createEmptyBorder(5, 5, 3, 5))));
        JPanel smoothPanel = new JPanel(new FlowLayout(0, 7, 0));
        this.smoothInfo = new MyLabel(this.SMOOTHINFO, 0, HELPFONT);
        this.smoothInfo.setVisible(this.showHelp);
        smoothPanel.add(this.smoothInfo);
        g.setConstraints(smoothPanel, c);
        p.add(smoothPanel);
        JPanel pLissage = new JPanel();
        pLissage.setLayout(new FlowLayout(0, 7, 0));
        this.smoothCb = new JCheckBox(this.USESM, null, true);
        this.smoothCb.setFont(Aladin.PLAIN);
        this.smoothCb.addActionListener(this);
        this.smooothLevelChoice = new JComboBox();
        for (int i = 2; i <= 4; ++i) {
            this.smooothLevelChoice.addItem(new Integer(i));
        }
        this.smooothLevelChoice.setSelectedIndex(0);
        this.smooothLevelChoice.setEnabled(true);
        this.lab1.setFont(Aladin.PLAIN);
        this.lab1.setEnabled(true);
        pLissage.add(this.smoothCb);
        pLissage.add(this.lab1);
        pLissage.add(this.smooothLevelChoice);
        g.setConstraints(pLissage, c);
        p.add(pLissage);
        JPanel noiseInfoPanel = new JPanel(new FlowLayout(0, 7, 0));
        this.noiseInfo = new MyLabel(this.NOISEINFO, 0, HELPFONT);
        this.noiseInfo.setVisible(this.showHelp);
        noiseInfoPanel.add(this.noiseInfo);
        g.setConstraints(noiseInfoPanel, c);
        p.add(noiseInfoPanel);
        JPanel noisecbPanel = new JPanel(new FlowLayout(0, 7, 0));
        this.noisecb = new JCheckBox(this.REDUCE, null, true);
        this.noisecb.setFont(Aladin.PLAIN);
        noisecbPanel.add(this.noisecb);
        g.setConstraints(noisecbPanel, c);
        p.add(noisecbPanel);
        JPanel zoomInfoPanel = new JPanel(new FlowLayout(0, 7, 0));
        this.zoomInfo = new MyLabel(this.ZOOMINFO, 0, HELPFONT);
        this.zoomInfo.setVisible(this.showHelp);
        zoomInfoPanel.add(this.zoomInfo);
        g.setConstraints(zoomInfoPanel, c);
        p.add(zoomInfoPanel);
        JPanel currentZoomOnlyPanel = new JPanel(new FlowLayout(0, 7, 0));
        this.currentZoomOnly = new JCheckBox(this.CONSIDER, false);
        this.currentZoomOnly.setFont(Aladin.PLAIN);
        currentZoomOnlyPanel.add(this.currentZoomOnly);
        g.setConstraints(currentZoomOnlyPanel, c);
        p.add(currentZoomOnlyPanel);
        try {
            this.currentZoomOnly.setEnabled(this.a.calque.getFirstSelectedSimpleImage().ref);
        }
        catch (Exception e) {
            this.currentZoomOnly.setEnabled(false);
        }
        this.helpBtn = this.createButton(this.showHelp ? this.HIDEHELP : this.SHOWHELP);
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        g.setConstraints(this.helpBtn, c);
        p.add(this.helpBtn);
        return p;
    }

    private JPanel getBottomPanel() {
        Insets myInsets = new Insets(0, 4, 0, 4);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new FlowLayout(1));
        this.submitBtn = this.createButton(this.SUBMIT);
        this.submitBtn.setFont(Aladin.BOLD);
        this.submitBtn.setMargin(myInsets);
        pButtons.add(this.submitBtn);
        pButtons.add(this.createButton(this.RESET));
        pButtons.add(this.createButton(this.CLOSE));
        return pButtons;
    }

    private void createAllPanels() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(null, this.TITRE2, 2, 2, Aladin.LBOLD)));
        p.add(this.getTopPanel());
        JPanel optionsPanel = this.getOptionsPanel();
        p.add(optionsPanel);
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        this.pack();
        this.show();
        this.flagHide = false;
    }

    @Override
    public void show() {
        this.initCouleurs();
        this.fillCouleurTriangle();
        super.show();
        this.flagHide = false;
    }

    @Override
    public void hide() {
        this.a.toolBox.tool[12].mode = this.a.calque.getFirstSelectedPlanImage() != null ? 1 : 0;
        this.a.toolBox.repaint();
        this.flagHide = true;
        this.etat = -1;
        super.hide();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void majContour() {
        if (this.a.toolBox.tool[12].mode == -1) {
            int newEtat;
            PlanImage p = this.a.calque.getFirstSelectedPlanImage();
            if (p == null || !p.flagOk || !p.isPixel() || this.etat == (newEtat = p.getImgID())) return;
            this.etat = newEtat;
            try {
                if (p instanceof PlanBG) {
                    ViewSimple v = this.a.view.getView(p);
                    if (v.rzoom.equals(this.memoRzoom)) return;
                    this.pimg = this.getCropImage(p);
                    this.memoRzoom = v.rzoom;
                } else {
                    this.pimg = p;
                }
            }
            catch (Exception e) {
                Aladin.error(this, e.getMessage());
                return;
            }
            this.createAllPanels();
            return;
        }
        this.hide();
    }

    PlanImage getCropImage(Plan p) throws Exception {
        if (!(p instanceof PlanBG)) {
            throw new Exception("Contour cropping only on all-sky image");
        }
        ViewSimple v = this.a.view.getCurrentView();
        if (v.pref != p) {
            throw new Exception("All-sky image contour is only available on current view !");
        }
        return this.a.calque.createCropImage(v, false);
    }

    private void fillCouleurTriangle() {
        for (int i = 0; i < this.curs.couleurTriangle.length; ++i) {
            this.curs.couleurTriangle[i] = this.couleurs[i];
        }
    }

    private void initCouleurs() {
        if (this.couleurs == null) {
            this.couleurs = new Color[20];
        }
        Color couleurBase = PlanContour.getNextColor(this.a.calque);
        Color[] base = Couleur.getBrighterColors(couleurBase, 4);
        for (int i = 0; i < this.couleurs.length; ++i) {
            this.couleurs[i] = base[i % base.length];
        }
    }

    private void adjustsmooothLevelChoice() {
        if (!this.smoothCb.isSelected()) {
            this.smooothLevelChoice.setEnabled(false);
            this.lab1.setEnabled(false);
        } else {
            this.smooothLevelChoice.setEnabled(true);
            this.lab1.setEnabled(true);
        }
    }

    private void parseLevels() {
        int i;
        this.levels = new double[this.curs.nbNiveaux];
        for (i = 0; i < this.curs.nbNiveaux; ++i) {
            this.levels[i] = this.curs.niveaux[i];
        }
        for (i = 0; i < this.levels.length; ++i) {
            double m = this.levels[i];
            Color couleurm = this.couleurs[i];
            for (int j = i + 1; j < this.levels.length; ++j) {
                if (!(this.levels[j] < m)) continue;
                double t = m;
                m = this.levels[j];
                this.levels[j] = t;
                Color couleurt = couleurm;
                couleurm = this.couleurs[j];
                this.couleurs[j] = couleurt;
                this.couleurs[i] = couleurm;
            }
            this.levels[i] = m;
        }
    }

    protected static int[] generateLevels(int n) {
        int min = 0;
        int max = 255;
        int[] tab = new int[n];
        double step = (max - min) / (n + 1);
        for (int i = 0; i < n; ++i) {
            tab[i] = (int)(step + step * (double)i);
        }
        return tab;
    }

    protected void reset() {
        this.curs.reset();
        this.curs.niveaux[0] = 100;
        this.curs.nbNiveaux = 1;
    }

    private void createLevels(int nbLevels) {
        this.curs.nbNiveaux = 0;
        int[] lev = FrameContour.generateLevels(nbLevels);
        for (int i = 0; i < lev.length; ++i) {
            this.curs.addCurseur(lev[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String what = ae.getActionCommand();
        Object target = ae.getSource();
        if (this.CLOSE.equals(what)) {
            this.hide();
        } else if (this.RESET.equals(what)) {
            this.reset();
        } else if (this.nbLevelsChoice.equals(target)) {
            int nbNiveaux = (Integer)this.nbLevelsChoice.getSelectedItem();
            this.createLevels(nbNiveaux);
        } else if (this.smoothCb.equals(target)) {
            this.adjustsmooothLevelChoice();
        } else if (this.helpBtn.equals(target)) {
            boolean bl = this.showHelp = !this.showHelp;
            if (this.showHelp) {
                this.helpBtn.setText(this.HIDEHELP);
            } else {
                this.helpBtn.setText(this.SHOWHELP);
            }
            this.smoothInfo.setVisible(this.showHelp);
            this.noiseInfo.setVisible(this.showHelp);
            this.zoomInfo.setVisible(this.showHelp);
            if (this.showHelp) {
                this.setLocation(this.getLocation().x, 70);
            } else {
                this.setLocation(this.getLocation().x, 200);
            }
            this.pack();
        } else if (this.SUBMIT.equals(what)) {
            this.hide();
            this.parseLevels();
            this.a.calque.newPlanContour("Contours", this.pimg, this.levels, new ContourPlot(), this.smoothCb.isSelected(), (Integer)this.smooothLevelChoice.getSelectedItem(), this.currentZoomOnly.isSelected(), this.noisecb.isSelected(), this.couleurs);
            this.a.console.printCommand("contour " + this.levels.length + (this.smoothCb.isSelected() ? "" : " nosmooth") + (this.currentZoomOnly.isSelected() ? " zoom" : ""));
            this.initCouleurs();
            this.fillCouleurTriangle();
            this.curs.repaint();
        } else if (this.NEWLEVEL.equals(what)) {
            this.curs.addCurseur();
        }
    }

    private JButton createButton(String s) {
        JButton b = new JButton(s);
        b.setFont(Aladin.PLAIN);
        b.setMargin(BUTTON_INSETS);
        b.addActionListener(this);
        return b;
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.hide();
        }
        return super.handleEvent(e);
    }
}

